/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.skill;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.api.client.IHudSkillRenderer;
import dev.toma.gunsrpg.api.common.skill.ICooldown;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.util.Interval;
import dev.toma.gunsrpg.util.RenderUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.vector.Matrix4f;

public class SkillCooldownRenderer<S extends ISkill & ICooldown>
implements IHudSkillRenderer<S> {
    @Override
    public void renderExtraSkillData(S skill, MatrixStack stack, FontRenderer renderer, int x, int y, int width, int height, float alpha) {
        int cooldown = ((ICooldown)skill).getCooldown();
        if (cooldown > 0 && alpha > 0.1f) {
            String text = Interval.format(cooldown, f -> f.src(Interval.Unit.TICK).out(Interval.Unit.HOUR, Interval.Unit.MINUTE, Interval.Unit.SECOND).compact());
            int textWidth = renderer.func_78256_a(text);
            float center = (float)x + (float)(width - textWidth) / 2.0f;
            int a = (int)(255.0f * alpha);
            Matrix4f pose = stack.func_227866_c_().func_227870_a_();
            int backgroundAlpha = (int)(alpha * 0.4f * 255.0f);
            RenderUtils.drawSolid(pose, (int)center - 2, y + height + 1, (int)center + textWidth + 2, y + height + 15, backgroundAlpha << 24);
            float progress = (float)((ICooldown)skill).getCooldown() / (float)((ICooldown)skill).getMaxCooldown();
            RenderUtils.drawSolid(pose, (int)center - 2, y + height + 14, (int)center + (int)(progress * (float)(textWidth + 2)), y + height + 15, 0xFF7700 | backgroundAlpha << 24);
            renderer.func_238405_a_(stack, text, center, (float)(y + height + 3), 0xFFFFFF | a << 24);
        }
    }
}

